/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.services;

import ch.dia.model.DiaDonnees;
import ch.dia.model.DiaProfil;
import ch.dia.model.DiaUtilisateur;
import ch.dia.services.HTMLTemplater;
import ch.dia.utils.ResourceBundleUtils;
import ch.dia.utils.utMail;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServices {
    public static final Logger LOGGER = LoggerFactory.getLogger(MailServices.class);
    private final HTMLTemplater htmlTemplater = new HTMLTemplater();

    void sendIncriptionEmail(DiaUtilisateur user, Locale locale) {
        utMail.sendMail(user.getEmail(), ResourceBundleUtils.getLocalText("msg.inscriptionWebdia", locale), this.htmlTemplater.getInscriptionEmail(user, locale));
    }

    void sendIncriptionEmailWithCopyTo(DiaUtilisateur medecin, Locale locale, boolean bNewUser, String password, DiaUtilisateur user) {
        utMail.sendMail(user.getEmail(), ResourceBundleUtils.getLocalText("msg.inscriptionWebdia", locale), this.htmlTemplater.getAffiliationEmailText(bNewUser, user, medecin, password, locale));
    }

    void sendPasswordRegenerated(DiaUtilisateur user, String password, Locale locale) {
        utMail.sendMail(user.getEmail(), "WebDia", this.htmlTemplater.getText(user, password, locale));
    }

    boolean sendMailProfilTo(DiaProfil pProfil, DiaUtilisateur pUser, Locale locale) {
        return utMail.sendMail(pUser.getEmail(), ResourceBundleUtils.getLocalText("msg.modifProfil", locale), this.htmlTemplater.getText(pUser, pProfil, locale));
    }

    boolean sendModifiedProfiltFromDoctor(DiaProfil pProfil, DiaUtilisateur medecin, DiaUtilisateur pPatient, Locale locale) {
        return utMail.sendMail(pPatient.getEmail(), ResourceBundleUtils.getLocalText("msg.doctorModifProfil", locale) + " " + medecin.getNomComplet(), this.htmlTemplater.getText(pPatient, pProfil, locale));
    }

    boolean sendContactEmail(String mail, String sujet, String message) {
        mail = StringEscapeUtils.unescapeJava((String)mail);
        sujet = StringEscapeUtils.unescapeJava((String)sujet);
        return utMail.sendMail(sujet, this.htmlTemplater.getContactContent(mail, message));
    }

    void sendMailWithFile(DiaUtilisateur user, String eMail, final Locale locale, final List<DiaDonnees> lst) {
        File file = null;
        try {
            file = File.createTempFile(user.getPrenom() + "_" + user.getNom(), ".csv");
            this.openPrintWriterAndDo(file, new Do(){

                @Override
                public void run(PrintWriter pw) throws Exception {
                    pw.println(ResourceBundleUtils.getLocalText("entete.csv", locale));
                    for (DiaDonnees pData : lst) {
                        pw.println(pData.getDateInj() + ";" + pData.getTimeInj() + ";" + pData.getGlycemie() + ";" + pData.getInjection() + ";" + pData.getNbHdc() + ";");
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("IOException during Export", e);
        }
        utMail.sendMail(eMail, ResourceBundleUtils.getLocalText("msg.mesGlycemies", locale), String.format("%s %s %s%s", ResourceBundleUtils.getLocalText("msg.fichierCsv", locale), user.getPrenom(), user.getNom() + "\n", ResourceBundleUtils.getLocalText("msg.politesse", locale) + "\n\n"), file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPrintWriterAndDo(File file, Do doWith) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(file, true));
        try {
            doWith.run(pw);
        }
        catch (Exception e) {
            LOGGER.error("Exception during use of PrintWriter", (Throwable)e);
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    private static interface Do {
        public void run(PrintWriter var1) throws Exception;
    }
}

