/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.pdf;

import ch.dia.dao.DaoDonnees;
import ch.dia.model.DiaDonnees;
import ch.dia.model.DiaUtilisateur;
import ch.dia.model.TypeHoraire;
import ch.dia.utils.utMath;
import com.itextpdf.text.Anchor;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chapter;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Section;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class DiaPdf {
    private static Image image;
    private static DiaUtilisateur diaUser;
    private static List lstDataU1;
    private static List lstDataU2;
    private static List lstDataU3;
    private static List lstDataU4;
    private static List lstDataU5;
    private static List lstDataU6;
    private static Font catFont;
    private static Font redFont;
    private static Font subFont;
    private static Font smallBold;
    private static DaoDonnees donneesOm;

    public DiaPdf(DaoDonnees donneesOm) {
        DiaPdf.donneesOm = donneesOm;
    }

    public static File rapport(DiaUtilisateur user, String sFile, String sDebut, String sFin) {
        File temp = null;
        try {
            diaUser = user;
            image = Image.getInstance((String)sFile);
            lstDataU1 = donneesOm.getUserData(diaUser.getId(), TypeHoraire.u1, sDebut, sFin, 0);
            lstDataU2 = donneesOm.getUserData(diaUser.getId(), TypeHoraire.u2, sDebut, sFin, 0);
            lstDataU3 = donneesOm.getUserData(diaUser.getId(), TypeHoraire.u3, sDebut, sFin, 0);
            lstDataU4 = donneesOm.getUserData(diaUser.getId(), TypeHoraire.u4, sDebut, sFin, 0);
            lstDataU5 = donneesOm.getUserData(diaUser.getId(), TypeHoraire.u5, sDebut, sFin, 0);
            lstDataU6 = donneesOm.getUserData(diaUser.getId(), TypeHoraire.u6, sDebut, sFin, 0);
            temp = File.createTempFile("tempfile", ".pdf");
            Document document = new Document();
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(temp));
            document.open();
            DiaPdf.addMetaData(document);
            DiaPdf.addTitlePage(document, sDebut, sFin);
            DiaPdf.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temp;
    }

    private static void addMetaData(Document document) {
        document.addTitle(diaUser.getNomComplet());
        document.addSubject("Glyc\u00e9mie");
        document.addKeywords("Java, PDF, iText");
        document.addAuthor("kmConcept");
        document.addCreator("kmConcept");
    }

    private static void addTitlePage(Document document, String debut, String fin) throws DocumentException {
        Paragraph preface = new Paragraph();
        DiaPdf.addEmptyLine(preface, 1);
        preface.add((Element)new Paragraph(diaUser.getNomComplet(), catFont));
        DiaPdf.addEmptyLine(preface, 1);
        preface.add((Element)new Paragraph("Glyc\u00e9mie du " + debut + " \u00e0 " + fin, smallBold));
        DiaPdf.addEmptyLine(preface, 3);
        preface.add((Element)new Paragraph("This document describes something which is very important ", smallBold));
        DiaPdf.addEmptyLine(preface, 8);
        preface.add((Element)new Paragraph("This document is a preliminary version and not subject to your license agreement or any other agreement with vogella.com ;-).", redFont));
        document.add((Element)preface);
        document.newPage();
    }

    private static void addContent(Document document) throws DocumentException {
        Anchor anchor = new Anchor("Glyc\u00e9mies", catFont);
        anchor.setName("Glyc\u00e9mies");
        Chapter catPart = new Chapter(new Paragraph((Phrase)anchor), 1);
        Paragraph subPara = new Paragraph("Glyc\u00e9mies du Petit d\u00e9jeuner", subFont);
        Section subCatPart = catPart.addSection(subPara);
        DiaPdf.addEmptyLine(subPara, 2);
        float moyenne = utMath.round(DiaPdf.createTable(subCatPart, lstDataU1), 2);
        subCatPart.add((Element)new Paragraph("Moyenne : " + Float.toString(moyenne)));
        subPara = new Paragraph("Glyc\u00e9mies de Midi", subFont);
        subCatPart = catPart.addSection(subPara);
        DiaPdf.addEmptyLine(subPara, 2);
        moyenne = utMath.round(DiaPdf.createTable(subCatPart, lstDataU3), 2);
        subCatPart.add((Element)new Paragraph("Moyenne : " + Float.toString(moyenne)));
        subPara = new Paragraph("Glyc\u00e9mies du D\u00eener", subFont);
        subCatPart = catPart.addSection(subPara);
        document.add((Element)image);
        document.add((Element)catPart);
    }

    private static float createTable(Section subCatPart, List lst) throws BadElementException {
        float moyenne = 0.0f;
        PdfPTable table = new PdfPTable(2);
        PdfPCell c1 = new PdfPCell(new Phrase("Date/heure"));
        c1.setHorizontalAlignment(1);
        table.addCell(c1);
        c1 = new PdfPCell(new Phrase("Glyc\u00e9mie"));
        c1.setHorizontalAlignment(1);
        table.addCell(c1);
        table.setHeaderRows(1);
        moyenne = 0.0f;
        if (lst.size() > 0) {
            for (int i = 0; i < lst.size(); ++i) {
                DiaDonnees data = (DiaDonnees)lst.get(i);
                table.addCell(data.getDateInj() + "/" + data.getTimeInj());
                table.addCell(Float.toString(data.getGlycemie().floatValue()));
                moyenne += data.getGlycemie().floatValue();
            }
            moyenne /= (float)lst.size();
        }
        subCatPart.add((Element)table);
        return moyenne;
    }

    private static void createList(Section subCatPart) {
        com.itextpdf.text.List list = new com.itextpdf.text.List(true, false, 10.0f);
        list.add((Element)new ListItem("First point"));
        list.add((Element)new ListItem("Second point"));
        list.add((Element)new ListItem("Third point"));
        subCatPart.add((Element)list);
    }

    private static void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    static {
        catFont = new Font(Font.FontFamily.TIMES_ROMAN, 18.0f, 1);
        redFont = new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 0, BaseColor.RED);
        subFont = new Font(Font.FontFamily.TIMES_ROMAN, 16.0f, 1);
        smallBold = new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 1);
    }
}

