/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.persistence.annotations.Index;

@Entity
@Table(name="dia_utilisateur")
@XmlRootElement
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="typeAcces", discriminatorType=DiscriminatorType.INTEGER)
public abstract class DiaUtilisateur
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="idSha")
    private String idSha;
    @Basic(optional=false)
    @Column(name="email", nullable=false)
    @Index(unique=true)
    @NotNull
    private String email;
    @Basic(optional=false)
    @Column(name="sexe")
    private Integer sexe;
    @Basic(optional=false)
    @Column(name="nom")
    private String nom;
    @Basic(optional=false)
    @Column(name="prenom")
    private String prenom;
    @Basic(optional=false)
    @Column(name="actif")
    private int actif;
    @Basic(optional=false)
    @Column(name="etude")
    private int etude;
    @Basic(optional=false)
    @Column(name="motpasse")
    private String motpasse;
    @Basic(optional=false)
    @Column(name="dt_creation")
    @Temporal(value=TemporalType.DATE)
    private Date dtCreation;
    @Basic(optional=false)
    @Column(name="dt_lastConnect")
    @Temporal(value=TemporalType.DATE)
    private Date dtLastConnect;

    public DiaUtilisateur() {
    }

    public DiaUtilisateur(int sexe, String nom, String prenom, String email, String motpasse) {
        this.sexe = sexe;
        this.nom = nom;
        this.prenom = prenom;
        this.email = email;
        this.motpasse = motpasse;
        this.actif = 1;
        this.etude = 0;
    }

    public DiaUtilisateur(String email) {
        this.email = email;
    }

    @PrePersist
    public void prePersist() {
        if (this.getDtCreation() == null) {
            this.setDtCreation(new Date());
        }
    }

    public Integer getId() {
        return this.id;
    }

    public DiaUtilisateur setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getIdSha() {
        return this.idSha;
    }

    public DiaUtilisateur setIdSha(String idSha) {
        this.idSha = idSha;
        return this;
    }

    public String getNomComplet() {
        String sNom = "";
        sNom = this.getSexe() == 1 ? "M. " : "Mme ";
        sNom = sNom + this.getPrenom() + " " + this.getNom();
        return sNom;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getActif() {
        return this.actif;
    }

    public void setActif(int actif) {
        this.actif = actif;
    }

    public int getEtude() {
        return this.etude;
    }

    public void setEtude(int actif) {
        this.etude = this.etude;
    }

    public String getMotpasse() {
        return this.motpasse;
    }

    public void setMotpasse(String motpasse) {
        this.motpasse = motpasse;
    }

    public Date getDtCreation() {
        return this.dtCreation;
    }

    public void setDtCreation(Date dtCreation) {
        this.dtCreation = dtCreation;
    }

    public Date getDtLastConnect() {
        return this.dtLastConnect;
    }

    public void setDtLastConnect(Date dtLastConnect) {
        this.dtLastConnect = dtLastConnect;
    }

    public Integer getSexe() {
        return this.sexe;
    }

    public void setSexe(Integer sexe) {
        this.sexe = sexe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiaUtilisateur that = (DiaUtilisateur)o;
        if (this.actif != that.actif) {
            return false;
        }
        if (this.etude != that.etude) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.idSha != null ? !this.idSha.equals(that.idSha) : that.idSha != null) {
            return false;
        }
        if (this.sexe != null ? !this.sexe.equals(that.sexe) : that.sexe != null) {
            return false;
        }
        if (this.nom != null ? !this.nom.equals(that.nom) : that.nom != null) {
            return false;
        }
        if (this.prenom != null ? !this.prenom.equals(that.prenom) : that.prenom != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.motpasse != null ? !this.motpasse.equals(that.motpasse) : that.motpasse != null) {
            return false;
        }
        if (this.dtCreation != null ? !this.dtCreation.equals(that.dtCreation) : that.dtCreation != null) {
            return false;
        }
        return this.dtLastConnect != null ? !this.dtLastConnect.equals(that.dtLastConnect) : that.dtLastConnect != null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.idSha != null ? this.idSha.hashCode() : 0);
        result = 31 * result + (this.sexe != null ? this.sexe.hashCode() : 0);
        result = 31 * result + (this.nom != null ? this.nom.hashCode() : 0);
        result = 31 * result + (this.prenom != null ? this.prenom.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + this.actif;
        result = 31 * result + this.etude;
        result = 31 * result + (this.motpasse != null ? this.motpasse.hashCode() : 0);
        result = 31 * result + (this.dtCreation != null ? this.dtCreation.hashCode() : 0);
        result = 31 * result + (this.dtLastConnect != null ? this.dtLastConnect.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ch.dia.model.DiaUtilisateur[ id=" + this.id + " ]";
    }
}

