/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.dao;

import ch.dia.dao.DaoAbstract;
import ch.dia.model.DiaDonnees;
import ch.dia.model.TypeHoraire;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DaoDonnees
extends DaoAbstract<DiaDonnees> {
    static final int LAST_DATA = 10;

    public DaoDonnees(EntityManager _em) {
        super(_em);
    }

    public DiaDonnees getData(int id) {
        return (DiaDonnees)DaoDonnees.getSingleResultOrNull(this.em().createQuery("SELECT d FROM DiaDonnees d WHERE d.id = :id", DiaDonnees.class).setParameter("id", (Object)id));
    }

    public List<DiaDonnees> getLastUserData(int idUser) {
        return this.em().createQuery("SELECT d FROM DiaDonnees d WHERE d.utilisateur.id = :idUti AND d.glycemieCapteur = 0 ORDER BY d.dateInj DESC, d.timeInj DESC", DiaDonnees.class).setParameter("idUti", (Object)idUser).setMaxResults(10).getResultList();
    }

    public List<DiaDonnees> getUserData(int idUser, TypeHoraire sHoraire, String dt, int glycemieAuto) {
        TypedQuery query = this.em().createQuery("SELECT d FROM DiaDonnees d WHERE d.glycemieAuto = 0 AND d.glycemieCapteur = 1 AND d.dateInj = :dt AND d.utilisateur.id = :idUti ORDER BY d.dateInj DESC, d.timeInj DESC", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("dt", (Object)dt);
        return query.getResultList();
    }

    public List<DiaDonnees> getUserData(int idUser, TypeHoraire sHoraire, String dtDebut, String dtFin, int glycemieAuto) {
        TypedQuery query = this.em().createQuery("SELECT d FROM DiaDonnees d WHERE d.glycemieAuto = :glycemie AND d.glycemieCapteur = 0 AND (d.dateInj BETWEEN :date1 AND :date2) AND d.utilisateur.id = :idUti ORDER BY d.dateInj DESC, d.timeInj DESC", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin).setParameter("glycemie", (Object)glycemieAuto);
        if (sHoraire != null) {
            switch (sHoraire) {
                case u0: {
                    break;
                }
                case u1: {
                    query = this.em().createNamedQuery("DiaDonnees.findByidUtiAndIntervalDateInjTimeInj", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("glycemie", (Object)glycemieAuto).setParameter("timeInj1", (Object)"06:00").setParameter("timeInj2", (Object)"09:30").setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin);
                    break;
                }
                case u2: {
                    query = this.em().createNamedQuery("DiaDonnees.findByidUtiAndIntervalDateInjTimeInj", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("glycemie", (Object)glycemieAuto).setParameter("timeInj1", (Object)"09:30").setParameter("timeInj2", (Object)"11:30").setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin);
                    break;
                }
                case u3: {
                    query = this.em().createNamedQuery("DiaDonnees.findByidUtiAndIntervalDateInjTimeInj", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("glycemie", (Object)glycemieAuto).setParameter("timeInj1", (Object)"11:30").setParameter("timeInj2", (Object)"15:00").setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin);
                    break;
                }
                case u4: {
                    query = this.em().createNamedQuery("DiaDonnees.findByidUtiAndIntervalDateInjTimeInj", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("glycemie", (Object)glycemieAuto).setParameter("timeInj1", (Object)"15:00").setParameter("timeInj2", (Object)"17:30").setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin);
                    break;
                }
                case u5: {
                    query = this.em().createNamedQuery("DiaDonnees.findByidUtiAndIntervalDateInjTimeInj", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("glycemie", (Object)glycemieAuto).setParameter("timeInj1", (Object)"17:30").setParameter("timeInj2", (Object)"20:00").setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin);
                    break;
                }
                case u6: {
                    query = this.em().createNamedQuery("DiaDonnees.findByidUtiAndIntervalDateInjTimeInjDebut", DiaDonnees.class).setParameter("idUti", (Object)idUser).setParameter("glycemie", (Object)glycemieAuto).setParameter("timeInj", (Object)"20:00").setParameter("date1", (Object)dtDebut).setParameter("date2", (Object)dtFin);
                }
            }
        }
        return query.getResultList();
    }

    public int removeDataCapteur(int idUser) {
        int numberRemove = this.em().createQuery("DELETE FROM DiaDonnees d WHERE d.glycemieCapteur = 1 AND d.utilisateur.id = :idUti ").setParameter("idUti", (Object)idUser).executeUpdate();
        if (numberRemove > 0) {
            this.em().flush();
        }
        return numberRemove;
    }

    public void saveDataCapteur(List<DiaDonnees> pData) {
        for (DiaDonnees data : pData) {
            this.em().persist((Object)data);
        }
        this.em().flush();
    }

    public DiaDonnees saveDonnees(DiaDonnees data) {
        if (data.getId() != null && this.em().find(DiaDonnees.class, (Object)data.getId()) != null) {
            data = (DiaDonnees)this.em().merge((Object)data);
        } else {
            this.em().persist((Object)data);
        }
        this.em().flush();
        return data;
    }
}

