/*
 * Decompiled with CFR 0.152.
 */
package ch.dia.dao;

import ch.dia.dao.Dao;
import ch.dia.dao.TxScope;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public abstract class DaoAbstract<T>
implements Dao<T> {
    private EntityManager _em;

    protected DaoAbstract(EntityManager em) {
        this._em = em;
    }

    public EntityManager em() {
        return this._em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U doInTx(TxScope<U> txScope) {
        EntityTransaction tx = this.em().getTransaction();
        if (!tx.isActive()) {
            tx.begin();
        }
        try {
            U u = txScope.run();
            if (tx.isActive()) {
                tx.commit();
            }
            U u2 = u;
            return u2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public static <T> T getSingleResultOrNull(TypedQuery<T> query) {
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return (T)results.get(0);
        }
        throw new NonUniqueResultException();
    }

    @Override
    public T saveEntity(T entity) {
        return this.saveEntity(entity, true);
    }

    @Override
    public T saveEntity(T entity, boolean shouldFlush) {
        if (this.em().contains(entity)) {
            entity = this.em().merge(entity);
        } else {
            this.em().persist(entity);
        }
        if (shouldFlush) {
            this.em().flush();
        }
        return entity;
    }

    public void removeEntity(T entity) {
        this.removeEntity(entity, true);
    }

    public void removeEntity(T entity, boolean shouldFlush) {
        if (entity != null) {
            this.em().remove(entity);
        }
        if (shouldFlush) {
            this.em().flush();
        }
    }
}

